<?php
/**
 * Account Lock
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

echo '<div class="page-title"><span>'.lang('accountlock_title',true).'</span></div>';

try {
	
	$AccountLock = new \Plugin\AccountLock\AccountLock();
	$AccountLock->setUser($_SESSION['username']);
	
	if(check_value($_GET['email'])) {
		
		$AccountLock->requestUnlockEmail();
		
	} else {
		
		if(!check_value($_GET['user'])) throw new Exception(lang('accountlock_error_11',true));
		if(!check_value($_GET['key'])) throw new Exception(lang('accountlock_error_11',true));
		if(!check_value($_GET['t'])) throw new Exception(lang('accountlock_error_11',true));
		if(!check_value($_GET['hash'])) throw new Exception(lang('accountlock_error_11',true));
		if($_SESSION['username'] != $_GET['user']) throw new Exception(lang('accountlock_error_11',true));
		
		$AccountLock->setKey($_GET['key']);
		$AccountLock->setTimestamp($_GET['t']);
		$AccountLock->setHash($_GET['hash']);
		$AccountLock->unlock();
		
	}
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}